from cvsgui.Macro import *
from cvsgui.CvsEntry import *
from cvsgui.Persistent import *
from cvsgui.ColorConsole import *
from cvsgui.MenuMgr import *

import cvsgui.App, os.path, string, os

class PlusUpdate(Macro):
	def __init__(self):
		Macro.__init__(self, "Update Application", MACRO_SELECTION,
			0, "PVX Plus")

	def OnCmdUI(self, cmdui):
		# enable only if one cvs file or folder is selected
		sel = cvsgui.App.GetSelection()
		isGood = (len(sel) == 1)  and not (sel[0].IsUnknown() )

		cmdui.Enable(isGood)
		if isGood:
			cmdui.SetText("Update '%s'" % sel[0].GetName())
		else:
			cmdui.SetText("Update Application")


	def Run(self):
		sel = cvsgui.App.GetSelection()
          	value =  sel[0].GetFullName()
                
                fh = os.popen("<PVXPLUSEXE> -hd *plus/proj/update -arg '%s'" % value, 'w')
                fh.close()

class PlusImport(Macro):
	def __init__(self):
		Macro.__init__(self, "Extract to CVS", MACRO_SELECTION,
			0, "PVX Plus")

	def OnCmdUI(self, cmdui):
		cmdui.Enable(1)

	def Run(self):
       		sel = cvsgui.App.GetSelection()
               	value = sel[0].GetFullName()

                fh = os.popen("<PVXPLUSEXE> -hd *plus/proj/extract -arg '%s'" % value,'w')
                fh.close()

class PlusTarget(Macro):
	def __init__(self):
		Macro.__init__(self, "Define Target Application", MACRO_SELECTION,
			0, "PVX Plus")

	def OnCmdUI(self, cmdui):
		sel = cvsgui.App.GetSelection()
		isGood = (len(sel) == 1)  and not (sel[0].IsFile() )
		cmdui.Enable(isGood)

	def Run(self):
        	sel = cvsgui.App.GetSelection()
          	value =  sel[0].GetFullName()
          	
                fh = os.popen("<PVXPLUSEXE> -hd *plus/proj/target -arg '%s'" % value,'w')
                fh.close()

class PlusMakeNew(Macro):
	def __init__(self):
		Macro.__init__(self, "New program/panel", MACRO_SELECTION,
			0, "PVX Plus")

	def OnCmdUI(self, cmdui):
		cmdui.Enable(1)

	def Run(self):
                fh = os.popen("<PVXPLUSEXE> -hd *plus/proj/makenew",'w')
                fh.close()

PlusUpdate()
PlusImport()
PlusTarget()
PlusMakeNew()

